﻿//////////////////////////////////////////////
// ScriptObjectReference.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class ScriptObjectInterpreterReference ;
	class ScriptObjectView ;
}

/// Includes ---------------------------------

// nkScripts
#include "../../Dll/DllDefines.h"

#include "../Functions/FunctionParameterType.h"

/// Internals --------------------------------

namespace nkScripts
{
	struct ScriptObjectReferenceStruct
	{
		ScriptObjectInterpreterReference* _reference = nullptr ;
		int _counter = 1 ;
	} ;
}

/// Class ------------------------------------

namespace nkScripts
{
	class DLL_SCRIPTS_EXPORT ScriptObjectReference final
	{
		public :

			// Constructor, destructor
			ScriptObjectReference () noexcept ;
			ScriptObjectReference (ScriptObjectInterpreterReference* reference) noexcept ;
			ScriptObjectReference (const ScriptObjectView& other) noexcept ;
			ScriptObjectReference (const ScriptObjectReference& other) noexcept ;
			ScriptObjectReference (ScriptObjectReference&& other) noexcept ;
			~ScriptObjectReference () ;

			// Getters
			ScriptObjectInterpreterReference* getInterpreterReference () const ;
			FUNCTION_PARAMETER_TYPE getType () const ;

			// Operators
			ScriptObjectReference& operator= (const ScriptObjectView& other) noexcept ;
			ScriptObjectReference& operator= (const ScriptObjectReference& other) noexcept ;
			ScriptObjectReference& operator= (ScriptObjectReference&& other) noexcept ;

		private :

			// Functions
			void _release () ;

		private :

			// Attributes
			ScriptObjectReferenceStruct* _structure ;
	} ;
}